/***************************************************************************
 *   Copyright (C) 2008 by Manuel Schrape                                  *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WDG_SETTINGS_H
#define WDG_SETTINGS_H

#include <QtGui/QWidget>
#include <QIcon>
#include <QToolButton>
#include <QComboBox>

#include "ui_wdg_Settings.h"
#include "../global.h"
#include "../Classes/cSettings.h"

class wdg_Settings : public QWidget, public Ui::wdg_Settings_UI
{
    Q_OBJECT

public:
    explicit wdg_Settings(QWidget *parent = 0);
    virtual ~wdg_Settings();

    void show_FCSettings(int Set,  int FCSettings[MaxParameter]);
    char *GetFCSettings();
    void set_Config(cSettings *pConfig);
    QString Version;

private:
    int Settings[MaxParameter];
    int ParameterSet[11][MaxParameter];
    cSettings *Config;

    void set_LED(QToolButton *ToolButton, bool On = false);

    QComboBox *setCombo(QComboBox *Combo, int Set, int Wert);
    int get_Value(QComboBox *Combo);
    void store_ParameterSet(int Set);

private slots:
    void slot_tbUp();
    void slot_tbDown();
    void slot_tbLeft();
    void slot_tbRight();

    void slot_LEDtoValue();
    void slot_ValuetoLED16(int Wert);
    void slot_ValuetoLED17(int Wert);

    void slot_LoadParameter();
    void slot_SaveParameter();
};

#endif // WDG_SETTINGS_H
